#include "iso_csg.inc"
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "functions.inc"
#include "metals.inc"

////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////

#declare p_micro2=
pigment{
 crackle turbulence 1
 color_map{
  [0.00 White*.7]
  [0.01 White*.7]
  [0.02 White]
  [1.00 White]
 }
 scale 5
}
#declare p_micro1=
pigment{
 cells 
 turbulence .5
 color_map{
  [0.0 White*.9]
  [1.0 White]
 }
 scale .01
}
// + average all the normals
#declare p_brushed_new=
pigment{
 average turbulence 0
 pigment_map{
  [0.0 p_micro1]
  [0.1 p_micro1 rotate 45*x]
  [0.2 p_micro1 rotate -45*x]
  [0.3 p_micro2]
  [0.4 p_micro1 rotate 45*y]
  [0.5 p_micro1 rotate -45*y]
  [0.6 p_micro1 rotate 90*z]
  [0.7 p_micro2 rotate 45]
  [0.8 p_micro1 rotate 45*z]
  [0.9 p_micro1 rotate 90*y]
  [1.0 p_micro1 rotate -45*z]
 }
 scale .1
}

// + declare the final normal as image_pattern
#declare n_brushed_new=
normal{pigment_pattern{p_brushed_new} .4}



#declare m_glass=
material{
 texture{
  T_Glass3
  normal{bumps .1 scale 4}
  finish{reflection{.01,.9 fresnel} conserve_energy}
 }
 interior{I_Glass}
}

#declare Plexiglas = 
                   material  // Glass
                   {   
                      texture
                      {      
                         pigment
                         {
                            color rgbf <1.0, 1.0, 1.0, 0.7>
                         }      
                      
                         finish
                         {
                            ambient 0.0
                            //phong 60
                            //phong_size 60
                            diffuse 0.0
                            specular 1.0
                            roughness 0.001
                            reflection
                            {
                               0.1 , 0.5
                               fresnel  off
                               falloff  1.0
                               exponent 1.0
                               metallic 0.0
                            }
                         }
                      }   
                      
                      interior
                      {
                         ior 1.5
                      }

                    }


#declare pencil_cartridge = 
   material  // pencil_cartridge
   {   
      texture
      {      
         pigment
         {
            color rgbt <0.827451, 0.827451, 0.827451, 0.7604>
         }      
         finish
         {
            ambient 0.776967
         }
      }
   }



#declare yellow_plastic = 
   material  // Material1
   {   
      texture
      {      
         pigment
         {
            color rgb <0.87451, 0.839216, 0.12549>
         }      
         finish
         {
            ambient 0.8 //0.6748
            phong 0//30
            phong_size 0.1 //0.4
         }
         normal
         {
         n_brushed_new
         }
      }
   }




#declare red_ink = 
   material  // red_ink
   {   
      texture
      {      
         pigment
         {
            color rgb <0.384314, 0.0, 0.0>
         }      
         finish
         {
            ambient rgb <0.604133, 0.0, 0.0>
         }
      }
   }



#declare blue_ink = 
   material  // blue_ink
   {   
      texture
      {      
         pigment
         {
            color rgb <0.010362, 0.0, 0.384>
         }      
         finish
         {
            ambient rgb <0.0, 0.0, 0.604167>
         }
      }
   }



#declare blue_plastic = 
   material  // Texture_Systo
   {   
      texture
      {      
         pigment
         {
            color rgb <0.0, 0.0, 0.98039>
         }      
         finish
         {
            ambient 0.1
            phong 0.2
         }
      }
   }


#declare red_plastic = 
   material  // Texture_Systo
   {   
      texture
      {      
         pigment
         {
            color rgb <0.98039, 0.0, 0.0>
         }      
         finish
         {
            ambient 0.1
            phong 0.2
         }
      }
   }





#declare Bronze_Metal_sans_phong = 
   material  // Bronze_Metal
   {   
      texture
      {      
         pigment
         {
            color rgb <0.55, 0.47, 0.14>
         }      
         finish
         {
            ambient 0.8
            diffuse 0.7
            brilliance 6.0
            phong 0.2
            phong_size 30.0
         }
      }
   }


#declare Bronze_Metal_avec_phong = 
   material  // Bronze_Metal
   {   
      texture
      {      
         pigment
         {
            color rgb <0.55, 0.47, 0.14>
         }      
         finish
         {
            ambient 0.8
            diffuse 0.7
            brilliance 6.0
            phong 0.8
            phong_size 60.0
         }
      }
   }






#declare feutre_body = 
   material  // feutre_body
   {   
      texture
      {      
         pigment
         {
            radial
            color_map
            {
               [ 0.0     rgbft <0.690196, 0.0, 0.345098, 0.0, 0.0> ]
               [ 0.5     rgbft <0.690196, 0.0, 0.345098, 0.0, 0.0> ]
               [ 0.5     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            }
            rotate -90*x
            frequency 3.0
            ramp_wave
         }
         normal
         {
         n_brushed_new
         }
      
         finish
         {
            ambient 0.6115
         }
      }
   }







#declare feutre_pointe_mauve = 
   material  // feutre pointe
   {   
      texture
      {      
         pigment
         {
            color rgb <0.717647, 0.0, 0.356863>
         }      
         finish
         {
            ambient 0.697833
         }
      }
   }


////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////

#declare interne_radius = 0.7;
#declare external_radius = 1;

////////////////////////////////////////////////////////////////////////////////////////////////
// PLASTIC BODY////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////

#declare fn_1= IC_Cylinder_Hole(<0.0,0,0>,<0,0,10>,external_radius,interne_radius ) 
#declare fn_hole=IC_Scale(IC_Rotate(IC_Cylinder(<-4,0,5>,<4,0,5>,0.1),60*z)<1,1,0.3>)
#declare fn_2=IC_Difference2(fn_1,fn_hole)
#declare fn_3= IC_Difference2   (
                        IC_Cone(<0,0,10>,external_radius,<0,0,12>,interne_radius+0.1),
                        IC_Cylinder(<0,0,9>,<0,0,13>,interne_radius)
                                )
#declare fn_SE=IC_Merge2(fn_2,fn_3)

// cylindrical shape  
#declare fn_R2=  IC_Box(<-2,0.8,-1>,<2,2,16>)
#declare fn_R3 = IC_Rotate (fn_R2,60*z)
#declare fn_R4 = IC_Rotate (fn_R2,120*z)
#declare fn_R5 = IC_Rotate (fn_R2,180*z)
#declare fn_R6 = IC_Rotate (fn_R2,240*z)
#declare fn_R7 = IC_Rotate (fn_R2,300*z)



#declare fn_S1= IC_Difference4(fn_SE,fn_R2,fn_R3,fn_R4)
#declare fn_S2= IC_Difference4(fn_S1,fn_R5,fn_R6,fn_R7)

#declare pencil_body = object{
        isosurface      {                                                                                     
                function { fn_S2(x, y, z) }  
                max_gradient 1.6 //1.6 
                contained_by { box { -8+z*5, 8+4*z } }
                  material {yellow_plastic}
//                material {Plexiglas}
//                material {m_glass}

//              photon block for an object
//                photons {
//                target 1.0          // spacing multiplier for photons hitting the object
//                refraction on
//                reflection on
                //collect off       // ignore photons
                //pass_through      // do not influence photons
//                        }

                        }
                                } 

#declare pencil_body_mauve = object{
        isosurface      {                                                                                     
                function { fn_S2(x, y, z) }  
                max_gradient 1.6 //1.6 
                contained_by { box { -8+z*5, 8+4*z } }
                  material {feutre_body}
//                material {Plexiglas}
//                material {m_glass}

//              photon block for an object
//                photons {
//                target 1.0          // spacing multiplier for photons hitting the object
//                refraction on
//                reflection on
                //collect off       // ignore photons
                //pass_through      // do not influence photons
//                        }

                        }
                                } 



#undef fn_1
#undef fn_2
#undef fn_hole
#undef fn_3
#undef fn_SE
#undef fn_R2
#undef fn_R3
#undef fn_R4
#undef fn_R5
#undef fn_R6
#undef fn_R7
#undef fn_S1
#undef fn_S2
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////




////////////////////////////////////////////////////////////////////////////////////////////////
// PENCIL HEAD
////////////////////////////////////////////////////////////////////////////////////////////////

#declare fn_1=  IC_Cylinder(<0.0,0,11>,<0,0,12>, interne_radius-0.1 ) 
#declare fn_2= IC_Cone(<0,0,12>,interne_radius+0.1,<0,0,12.5>,0.5)
#declare fn_3= IC_Cone(<0,0,12.5>,0.5,<0,0,12.85>,0.1)
#declare fn_ball = IC_Scale(IC_Sphere(<0,0,12.85>,0.1),<1,1,1>)
#declare fn_4 = IC_Cone (<0,0,12.75>, 0.25,<0,0,13.0>,0.1)
#declare fn_feutre=IC_Translate(fn_4,0)
   
#declare fn_head_sombre=IC_Merge2(fn_1,fn_2)   

#declare pencil_head =          union   {   
isosurface      {                                                                                     
                  function { fn_head_sombre(x, y, z) }  
                  max_gradient 1.6 //1.6 
                  contained_by { box { -8+z*5, 8+8*z } }
                  material {Bronze_Metal_sans_phong}
                } 
isosurface      {                                                                                     
                  function { fn_3(x, y, z) }  
                  max_gradient 1.6 //1.6 
                  contained_by { box { -8+z*5, 8+8*z } }
                  material {Bronze_Metal_avec_phong}
                } 
                                        }


#declare pencil_head_blue =     union   {   
isosurface      {                                                                                     
                  function { fn_head_sombre(x, y, z) }  
                  max_gradient 1.6 //1.6 
                  contained_by { box { -8+z*5, 8+8*z } }
                  material {blue_plastic}
                } 
isosurface      {                                                                                     
                  function { fn_3(x, y, z) }  
                  max_gradient 1.6 //1.6 
                  contained_by { box { -8+z*5, 8+8*z } }
                  material {blue_plastic}
                }
                             
                                        }

#declare pencil_ball_blue = object   {
isosurface {                                                                                     
        function { fn_ball(x, y, z) }  
        max_gradient 1.5 //1.6 
        contained_by { box { -8+z*5, 8+8*z } }
        material {blue_ink} 
//        color rgb<1,0,0>
            }
                                 
                                 }

#declare pencil_ball_red = object   {
isosurface {                                                                                     
        function { fn_ball(x, y, z) }  
        max_gradient 1.0 //1.6 
        contained_by { box { -8+z*5, 8+8*z } }
        material {red_ink} 
//        color rgb<1,0,0>
            }
                                 
                                 }

#declare pencil_feutre_mauve = object   {
isosurface {                                                                                     
        function { fn_feutre(x, y, z) }  
        max_gradient 1.6 //1.6 
        contained_by { box { -8+z*5, 8+8*z } }
        material {feutre_pointe_mauve} 
//        color rgb<1,0,0>
            }
                                 
                                 }


#undef fn_1
#undef fn_2
#undef fn_3
#undef fn_4
#undef fn_ball
#undef fn_feutre
#undef fn_head_sombre


////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////
// PENCIL CARTRIDGE
////////////////////////////////////////////////////////////////////////////////////////////////

#declare fn_1=  IC_Cylinder(<0.0,0,4>,<0,0,11>, interne_radius-0.4 ) 
#declare fn_2 = IC_Cylinder_Hole(<0,0,1>,<0,0,11>,interne_radius-0.3,interne_radius-0.4)

#declare pencil_cartridge_blue = union      {

isosurface {                                                                                     
          function { fn_1(x, y, z) }  
          max_gradient 1.1 //1.6 
          contained_by { box { -8+z*5, 8+8*z } }
          material {blue_ink} 
           }                                        
isosurface {                                                                                     
          function { fn_2(x, y, z) }  
          max_gradient 1.0 //1.6 
          contained_by { box { -8+z*5, 8+8*z } }
          material {pencil_cartridge} 
           }                                        

                                        }


#declare pencil_cartridge_red = union      {

isosurface {                                                                                     
          function { fn_1(x, y, z) }  
          max_gradient 1.0 //1.6 
          contained_by { box { -8+z*5, 8+8*z } }
          material {red_ink} 
           }                                        
isosurface {                                                                                     
          function { fn_2(x, y, z) }  
          max_gradient 1.0 //1.6 
          contained_by { box { -8+z*5, 8+8*z } }
          material {pencil_cartridge} 
           }                                        

                                        }

#undef fn_1
#undef fn_2
                                        

////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////
// PENCIL BOTTOM
////////////////////////////////////////////////////////////////////////////////////////////////
#declare fn_1=  IC_Difference2  (
                        IC_Scale(IC_Sphere(<0.0,0,0.1>,external_radius-0.1 ),<1,1,0.2>),
                        IC_Box(<-1,-1,0>,<1,1,1>)
                                ) 
#declare fn_2= IC_Cylinder_Hole(<0,0,0>,<0,0,0.5>,interne_radius,interne_radius-0.1)

#declare fn_3=IC_Merge2(fn_1,fn_2)                                

#declare pencil_bottom_blue = object      {
isosurface {                                                                                     
          function { fn_3(x, y, z) }  
          max_gradient 1.1 //1.6 
          contained_by { box { -8+z*5, 8+8*z } }
          material {blue_plastic} 
           }                                        
                                        }

#declare pencil_bottom_red = object      {
isosurface {                                                                                     
          function { fn_3(x, y, z) }  
          max_gradient 1.0 //1.6 
          contained_by { box { -8+z*5, 8+8*z } }
          material {red_plastic} 
           }                                        
                                        }

#declare pencil_bottom_mauve = object      {
isosurface {                                                                                     
          function { fn_3(x, y, z) }  
          max_gradient 1.0 //1.6 
          contained_by { box { -8+z*5, 8+8*z } }
          material {feutre_pointe_mauve} 
           }                                        
                                        }

#undef fn_1
#undef fn_2
#undef fn_3


////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////


// CSG union, add all of shapes 1...N
#declare stylo_red = object {
union {
  object {pencil_body}
  object {pencil_head}
  object {pencil_ball_red}
  object {pencil_cartridge_red}
  object {pencil_bottom_red}
}
                         }

#declare stylo_blue = object {
union {
  object {pencil_body}
  object {pencil_head}
  object {pencil_ball_blue}
  object {pencil_cartridge_blue}
  object {pencil_bottom_blue}
}
                         }


#declare feutre_mauve = 
union {
  object {pencil_body_mauve}
  object {pencil_head_blue}
  object {pencil_feutre_mauve}
  object {pencil_bottom_mauve}

                         }

////////////////////////////////////////////////////////////////////////////////////////////////
// PENCIL BOUCHON
////////////////////////////////////////////////////////////////////////////////////////////////

#declare fn_1=  IC_Cylinder_Hole(<0.0,0,0.0>,<0,0,0.2>, external_radius+0.3,external_radius ) 

#declare fn_2 = IC_Difference4  (
                        IC_Scale(IC_Sphere (<0,0,0>, external_radius+0.1),<1,1,6>),
                        IC_Scale(IC_Sphere (<0,0,0>, external_radius),<1,1,6>),
                        IC_Cylinder(<0,0,0>,<0,0,7>,0.2),
                        IC_Plane(z,0)
                                )

#declare fn_3 = IC_Merge2(fn_1,fn_2)

#declare fn_4 = IC_Cylinder(<external_radius+0.1,0,-4>,<external_radius+0.1,0,+3>,0.3)
#declare fn_5 = IC_Sphere (<external_radius+0.1,0,-4>,0.3)
#declare fn_6 = IC_Sphere (<external_radius+0.1,0,+3>,0.3)

#declare fn_7 = IC_Difference2  (
        IC_Merge3(fn_4,fn_5,fn_6),
        IC_Scale(IC_Sphere (<0,0,0>, external_radius),<1,1,6>)
                                )
#declare fn_8 = IC_Merge2(fn_3,fn_7)


#declare pencil_bouchon_blue = object      {
isosurface {                                                                                     
          function { fn_8(x, y, z) }  
          max_gradient 1.8 //1.6 
          contained_by { box { -8-z*5, 8+8*z } }
          material {blue_plastic} 
           }                                        
                                        }


#declare pencil_bouchon_red = object      {
isosurface {                                                                                     
          function { fn_8(x, y, z) }  
          max_gradient 1.6 //1.6 
          contained_by { box { -8-z*5, 8+8*z } }
          material {red_plastic} 
           }                                        
                                        }


#undef fn_1
#undef fn_2
#undef fn_3
#undef fn_4
#undef fn_5
#undef fn_6
#undef fn_7
#undef fn_8


////////////////////////////////////////////////////////////////////////////////////////////////
// FEUTRE  BOUCHON
////////////////////////////////////////////////////////////////////////////////////////////////


#declare fn_1=  IC_Cylinder_Hole(<0.0,0,0.0>,<0,0,0.2>, external_radius+0.3,external_radius ) 

#declare fn_2 = IC_Difference3  (
                        IC_Cylinder (<0,0,0>,<0,0,6>, external_radius+0.1),
                        //IC_Scale(IC_Sphere (<0,0,0>, external_radius),<1,1,6>),
                        IC_Cone (<0,0,0>, external_radius+0.1,<0,0,3>,external_radius-0.5)
                        IC_Plane(z,0)
                                )
#declare fn_3=  IC_Translate(IC_Scale(IC_Cylinder(<-2,-1.15,6>,<+2,-1.15,6>,1),<1,1,1.3>),-1.8*z)
#declare fn_4=  IC_Translate(IC_Scale(IC_Cylinder(<-2,+1.15,6>,<+2,+1.15,6>,1),<1,1,1.3>),-1.8*z)
#declare fn_5 = IC_Difference3  (
                        IC_Merge2(fn_1,fn_2),
                        fn_3,
                        fn_4
                                )



#declare fn_6 = IC_Cylinder(<external_radius+0.1,0,-4>,<external_radius+0.1,0,+3>,0.3)
#declare fn_7 = IC_Sphere (<external_radius+0.1,0,-4>,0.3)
#declare fn_8 = IC_Sphere (<external_radius+0.1,0,+3>,0.3)

#declare fn_9 = IC_Difference2  (
        IC_Merge3(fn_6,fn_7,fn_8),
        IC_Scale(IC_Sphere (<0,0,0>, external_radius),<1,1,6>)
                                )
#declare fn_10=IC_Merge2(fn_9,fn_5)
#declare feutre_bouchon_mauve = object      {
isosurface {                                                                                     
          function { fn_10(x, y, z) }  
          max_gradient 1.6 //1.6 
          contained_by { box { -8-z*5, 8+8*z } }
          material {feutre_pointe_mauve} 
           }                                        
                                        }
                                        

#undef fn_1
#undef fn_2
#undef fn_3
#undef fn_4
#undef fn_5
#undef fn_6
#undef fn_7
#undef fn_8
#undef fn_9
#undef fn_10
                                                